#ifndef CE2_TST_RSA_2_H
#define CE2_TST_RSA_2_H

/*
* All the includes that are needed for code using this module to
* Compile correctly should be #included here.
*/
#include "CryptoEngine2.h"
#include "CE2_TST_Config.h"
#include "CE2_TST_Common.h"
#include "math.h"
#include <stdio.h>

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : 
* Last modified : 
*/
/** @file
* \brief This file contains test functions for RSA cryptography
* which worked with LibTomCrypt.
* 
* \version CE2_TST_RSA_2.h#1:csrc:1
* \author Yermolayeu Ihar
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables **********************/
/************************ Public Functions **********************/

/***************************************************************
* Function Name: 
*  CE2_TST_RSA_SHEME_EncDec_01
*
* Inputs:
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  Additional test for RSA_SHEME_EncDec.
*
* \b
* Algorithm:
***************************************************************/
CE2Error_t CE2_TST_RSA_SHEME_EncDec_01(FILE *out);

/***************************************************************
* Function Name: 
*  CE2_TST_RSA_SHEME_SignVerify_ZeroMessage_01
*
* Inputs:
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  Additional test for RSA.
*
* \b
* Algorithm:
***************************************************************/
CE2Error_t CE2_TST_RSA_SHEME_SignVerify_ZeroMessage_01(FILE *out);

#ifdef __cplusplus
}
#endif

#endif /* CE2_TST_RSA_2_H */
